/*
 * Decompiled with CFR 0.152.
 */
package net.caffeinemc.mods.sodium.client.config.builder;

import com.google.common.collect.ImmutableList;
import java.util.ArrayList;
import java.util.List;
import net.caffeinemc.mods.sodium.api.config.structure.OptionBuilder;
import net.caffeinemc.mods.sodium.api.config.structure.OptionGroupBuilder;
import net.caffeinemc.mods.sodium.api.config.structure.OptionPageBuilder;
import net.caffeinemc.mods.sodium.client.config.builder.OptionGroupBuilderImpl;
import net.caffeinemc.mods.sodium.client.config.builder.PageBuilderImpl;
import net.caffeinemc.mods.sodium.client.config.structure.OptionGroup;
import net.caffeinemc.mods.sodium.client.config.structure.OptionPage;
import net.minecraft.class_2561;
import org.apache.commons.lang3.Validate;

class OptionPageBuilderImpl
extends PageBuilderImpl
implements OptionPageBuilder {
    private final List<OptionGroup> groups = new ArrayList<OptionGroup>();
    private final List<OptionBuilder> looseOptions = new ArrayList<OptionBuilder>();

    OptionPageBuilderImpl() {
    }

    @Override
    void prepareBuild() {
        super.prepareBuild();
        if (this.looseOptions.isEmpty()) {
            Validate.notEmpty(this.groups, (String)"At least one group or loose option must be added", (Object[])new Object[0]);
        }
    }

    @Override
    OptionPage build() {
        this.prepareBuild();
        if (!this.looseOptions.isEmpty()) {
            OptionGroupBuilderImpl implicitGroup = new OptionGroupBuilderImpl();
            this.looseOptions.forEach(implicitGroup::addOption);
            this.addOptionGroup(implicitGroup);
        }
        return new OptionPage(this.name, (ImmutableList<OptionGroup>)ImmutableList.copyOf(this.groups));
    }

    @Override
    public OptionPageBuilder addOptionGroup(OptionGroupBuilder group) {
        this.groups.add(((OptionGroupBuilderImpl)group).build());
        return this;
    }

    @Override
    public OptionPageBuilder addOption(OptionBuilder option) {
        this.looseOptions.add(option);
        return this;
    }

    @Override
    public OptionPageBuilderImpl setName(class_2561 name) {
        super.setName(name);
        return this;
    }
}

